C PROGRAMA EFEMERIDES
C CREADO EN LA CLASE DE ASTRONOMIA FUNDAMENTAL Y SISTEMA SOLAR
C EN 2006 CON TABARE JUNTO A SOFIA Y MAGDALENA
C ACTUALIZADO EN 2018 (HAY 11 HACIENDO EL 2DO PARCIAL)
      IMPLICIT REAL*8(A-H,O-Z)
      
      GAUSS=0.01720209895D0
      PI=DATAN(1.0D0)*4.0D0
      DOSPI=2.0D0*PI
      OBLI=23.439291D0*PI/180.0D0

      OPEN(1,FILE="datos.dat",STATUS="OLD")
C LEE ELEMENTOS OBJETO: a, e, i, w, nodo, M, t, masa
      READ(1,*) A2,E2,YNC2,W2,OD2,AME2,T2,ASAM2
C LEE ELEMENTOS TIERRA O PLANETA DESDE DONDE SE OBSERVA
      READ(1,*) A1,E1,YNC1,W1,OD1,AME1,T1,ASAM1
C JD INICIAL
      READ(1,*) TINI
C NUMERO DE DIAS PARA CALCULO DE EFEMERIDES
      READ(1,*) NC
      CLOSE(1)
      
      YNC2=YNC2*PI/180.D0
      YNC1=YNC1*PI/180.D0
      W1=W1*PI/180.D0
      OD1=OD1*PI/180.D0
      AME1=AME1*PI/180.D0
      W2=W2*PI/180.D0
      OD2=OD2*PI/180.D0
      AME2=AME2*PI/180.D0
C ARCHIVO DE SALIDA
      OPEN(2,FILE="EFEM.DAT",STATUS="UNKNOWN",ACCESS="APPEND")
C MOVIMIENTOS MEDIOS Y PARAMETROS DE LAS ELIPSES
      V2N=GAUSS/A2**1.5D0*(1.0D0+ASAM2)**0.5D0
      V1N=GAUSS/A1**1.5D0*(1.0D0+ASAM1)**0.5D0
      P2=A2*(1.0D0-E2*E2)
      P1=A1*(1.0D0-E1*E1)

      TIEMPO=TINI-1.D0
C COMIENZA LOOP----------------------------------
      DO 200 I=1,NC
        TIEMPO=TIEMPO+1.0D0
        
C CALCULOS OBJETO
        AM2=V2N*(TIEMPO-T2)+AME2
  10    IF(AM2.GT.DOSPI) THEN
          AM2=AM2-DOSPI
          GOTO 10
        ENDIF
  20    IF(AM2.LT.0.0D0) THEN
          AM2=AM2+DOSPI
          GOTO 20
        ENDIF
        CALL KEPLER(E2,AM2,AEX2)
        R2=A2*(1.0D0-E2*DCOS(AEX2))
        F2=DACOS((P2/R2-1.0D0)/E2)
        IF(AM2.GT.PI) THEN
          F2=DOSPI-F2
        ENDIF
C PASO A XYZ
        X2=R2*DCOS(F2)
        Y2=R2*DSIN(F2)
        Z2=0.0D0
C ROTACION EN Z
        CALL ROTAZ(X2,Y2,Z2,-W2,XP,YP,ZP)
C ROTACION EN X
        CALL ROTAX(XP,YP,ZP,-YNC2,XR,YR,ZR)
C ROTACION EN Z
        CALL ROTAZ(XR,YR,ZR,-OD2,XE2,YE2,ZE2)

C CALCULOS TIERRA O PLANETA DEL OBSERVAOR
        AM1=V1N*(TIEMPO-T1)+AME1
  11    IF(AM1.GT.DOSPI) THEN
          AM1=AM1-DOSPI
          GOTO 11
        ENDIF
  21    IF(AM1.LT.0.0D0) THEN
          AM1=AM1+DOSPI
          GOTO 21
        ENDIF
        CALL KEPLER(E1,AM1,AEX1)
        R1=A1*(1.0D0-E1*DCOS(AEX1))
        F1=DACOS((P1/R1-1.0D0)/E1)
        IF(AM1.GT.PI) THEN
          F1=DOSPI-F1
        ENDIF
C PASO A XYZ
        X1=R1*DCOS(F1)
        Y1=R1*DSIN(F1)
        Z1=0.0D0
C ROTACION EN Z
        CALL ROTAZ(X1,Y1,Z1,-W1,XP,YP,ZP)
C ROTACION EN X
        CALL ROTAX(XP,YP,ZP,-YNC1,XR,YR,ZR)
C ROTACION EN Z
        CALL ROTAZ(XR,YR,ZR,-OD1,XE1,YE1,ZE1)

C CALCULO GEOCENTRICO O PLANETOCENTRICO
        XG=XE2-XE1
        YG=YE2-YE1
        ZG=ZE2-ZE1
C DIST GEOC
        DELTA=DSQRT(XG*XG+YG*YG+ZG*ZG)
C PASO A ESFERICAS ECLIPTICAS
      BETA=DASIN(ZG/DELTA)
      ECLO=DACOS(XG/DELTA/DCOS(BETA))
      IF(YG.LT.0.0D0) THEN
        ECLO=DOSPI-ECLO
      ENDIF
      GBETA=BETA*180.0D0/PI
      GECLO=ECLO*180.0D0/PI
C PASO A ECUATORIALES
C ROTACION EN X
        CALL ROTAX(XG,YG,ZG,-OBLI,XF,YF,ZF)
C PASO A ESFERICAS
      DEC=DASIN(ZF/DELTA)
      AR=DACOS(XF/DELTA/DCOS(DEC))
      IF(YF.LT.0.0D0) THEN
        AR=DOSPI-AR
      ENDIF
      GDEC=DEC*180.0D0/PI
      HAR=AR*180.0D0/PI/15.0D0
      
      COSELO=-(XE1*XG+YE1*YG+ZE1*ZG)/R1/DELTA
      ELONG=DACOS(COSELO)*180.D0/PI
      CAFASE=((XE2*XG+YE2*YG+ZE2*ZG)/R2/DELTA)
      AFASE=DACOS(CAFASE)*180.D0/PI
      FASE=(1.D0+CAFASE)/2.D0
      
      WRITE(2,33) TIEMPO,HAR,GDEC,GECLO,GBETA,R2,DELTA,ELONG,AFASE,FASE
  200  CONTINUE
C FIN LOOP----------------------------------------------
      CLOSE(2)
 33   FORMAT(F12.2,4F12.6,2F11.6,2F8.3,F6.3)

      STOP
      END
C-----------------------------------------------------------------
      SUBROUTINE KEPLER(EXCE,ANOMEDIA,ANOMEX)
      IMPLICIT REAL*8(A-H,O-Z)
      E=ANOMEDIA
      DO I=1,100
        E=ANOMEDIA+EXCE*DSIN(E)
      ENDDO
      ANOMEX=E
      RETURN
      END
C-----------------------------------------------------------------
      SUBROUTINE ROTAX(XI,YI,ZI,ANG,XF,YF,ZF)
      IMPLICIT REAL*8(A-H,O-Z)
      YF=YI*DCOS(ANG)+ZI*DSIN(ANG)
      ZF=-YI*DSIN(ANG)+ZI*DCOS(ANG)
      XF=XI
      RETURN
      END
C-----------------------------------------------------------------
      SUBROUTINE ROTAZ(XI,YI,ZI,ANG,XF,YF,ZF)
      IMPLICIT REAL*8(A-H,O-Z)
      XF=XI*DCOS(ANG)+YI*DSIN(ANG)
      YF=-XI*DSIN(ANG)+YI*DCOS(ANG)
      ZF=ZI
      RETURN
      END
C-----------------------------------------------------------------

