(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11123,        411]
NotebookOptionsPosition[      9088,        336]
NotebookOutlinePosition[      9552,        357]
CellTagsIndexPosition[      9483,        352]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
ELIPSE
Obtencion de posicion y velocidad a aprtir de elementos orbitales.
Curso Mecanica Celeste 2005. Tabare Gallardo.\
\>", "Section"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"unidad", " ", "de", " ", "tiempo"}], " ", "=", " ", "dia"}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"unidad", " ", "de", " ", "distancia"}], " ", "=", " ", "ua"}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"unidad", " ", "de", " ", "masa"}], " ", "=", " ", "sol"}], 
  TraditionalForm]}], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.16]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}},
 CellTags->"S5.16.1"],

Cell[BoxData[{
 RowBox[{"M", ":=", "1.0"}], "\[IndentingNewLine]", 
 RowBox[{"m", ":=", "0.0009548"}], "\[IndentingNewLine]", 
 RowBox[{"kgauss", ":=", "0.01720209895"}], "\[IndentingNewLine]", 
 RowBox[{"\[Mu]", ":=", 
  RowBox[{"kgauss", "*", "kgauss", "*", 
   RowBox[{"(", 
    RowBox[{"M", "+", "m"}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"a", ":=", "5.179995814935037"}], "\[IndentingNewLine]", 
 RowBox[{"e", ":=", "0.04871959170445102"}], "\[IndentingNewLine]", 
 RowBox[{"i", ":=", 
  RowBox[{"1.3046833201072958", "*", 
   RowBox[{"Pi", "/", "180"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Omega]", ":=", 
  RowBox[{
   RowBox[{"-", "84.90588389067327"}], "*", 
   RowBox[{"Pi", "/", "180"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalOmega]", ":=", 
  RowBox[{"100.48313071118518", "*", 
   RowBox[{"Pi", "/", "180"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"T", ":=", 
  RowBox[{"-", "81.299453540603"}]}], "\[IndentingNewLine]", 
 RowBox[{"t", ":=", "0.0"}]}], "Input",
 CellLabel->"In[320]:="],

Cell[CellGroupData[{

Cell["Esta kepler me la paso Daniel Chagas.", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"kepler", "[", 
   RowBox[{"tt_", ",", "\[Epsilon]_", ",", "mm_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"lista", "=", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"ee", "=", "tt"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"j", "=", "1"}], ",", 
       RowBox[{"j", "\[LessEqual]", "mm"}], ",", 
       RowBox[{"j", "++"}], ",", 
       RowBox[{
        RowBox[{"ee", "=", 
         RowBox[{"tt", "+", 
          RowBox[{"\[Epsilon]", "*", 
           RowBox[{"Sin", "[", "ee", "]"}]}]}]}], ";", 
        RowBox[{"lista", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"lista", ",", "ee"}], "]"}]}]}]}], "]"}], ";", 
     RowBox[{"Return", "[", "lista", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[331]:="],

Cell[BoxData[
 RowBox[{"n", ":=", 
  SqrtBox[
   FractionBox["\[Mu]", 
    SuperscriptBox["a", "3"]]]}]], "Input",
 CellLabel->"In[332]:="],

Cell[BoxData[{
 RowBox[{"p", ":=", 
  RowBox[{"a", "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"e", "*", "e"}]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"h", ":=", 
  SqrtBox[
   RowBox[{"p", "*", "\[Mu]"}]]}]}], "Input",
 CellLabel->"In[333]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AM1", "=", 
  RowBox[{"n", "*", 
   RowBox[{"(", 
    RowBox[{"t", "-", "T"}], ")"}]}]}]], "Input",
 CellLabel->"In[335]:="],

Cell[BoxData["0.11868127079196614`"], "Output",
 CellLabel->"Out[335]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AM", "=", 
  RowBox[{"Mod", "[", 
   RowBox[{"AM1", ",", 
    RowBox[{"2", "*", "Pi"}]}], "]"}]}]], "Input",
 CellLabel->"In[336]:="],

Cell[BoxData["0.11868127079196614`"], "Output",
 CellLabel->"Out[336]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kepler", "[", 
  RowBox[{"AM", ",", "e", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[337]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.1244498096820721`", ",", "0.1247287760746062`", ",", 
   "0.12474226185559048`", ",", "0.12474291377267348`", ",", 
   "0.1247429452870149`", ",", "0.12474294681045048`", ",", 
   "0.12474294688409492`", ",", "0.12474294688765496`", ",", 
   "0.12474294688782706`", ",", "0.12474294688783538`", ",", 
   "0.12474294688783578`", ",", "0.1247429468878358`", ",", 
   "0.1247429468878358`", ",", "0.1247429468878358`", ",", 
   "0.1247429468878358`", ",", "0.1247429468878358`", ",", 
   "0.1247429468878358`", ",", "0.1247429468878358`", ",", 
   "0.1247429468878358`", ",", "0.1247429468878358`"}], "}"}]], "Output",
 CellLabel->"Out[337]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AE", "=", 
  RowBox[{"Last", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[338]:="],

Cell[BoxData["0.1247429468878358`"], "Output",
 CellLabel->"Out[338]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"a", "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"e", "*", 
      RowBox[{"Cos", "[", "AE", "]"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[339]:="],

Cell[BoxData["4.929589507707512`"], "Output",
 CellLabel->"Out[339]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[Theta]", ":=", 
  RowBox[{
   RowBox[{"Sign", "[", "AE", "]"}], "*", 
   RowBox[{"ArcCos", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"p", "/", "r"}], "-", "1"}], "e"], "]"}]}]}]], "Input",
 CellLabel->"In[340]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "\[Theta]"}], "}"}]], "Input",
 CellLabel->"In[341]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.929589507707512`", ",", "0.13095852775833072`"}], 
  "}"}]], "Output",
 CellLabel->"Out[341]="]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"\[Xi]", ":=", 
  RowBox[{"r", "*", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Eta]", ":=", 
  RowBox[{"r", "*", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Zeta]", ":=", "0"}]}], "Input",
 CellLabel->"In[342]:="],

Cell[BoxData[
 RowBox[{"vecpos", ":=", 
  RowBox[{"{", 
   RowBox[{"\[Xi]", ",", "\[Eta]", ",", "\[Zeta]"}], "}"}]}]], "Input",
 CellLabel->"In[345]:="],

Cell[BoxData[{
 RowBox[{"xp", ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "h"}], "/", "p"}], "*", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"yp", ":=", 
  RowBox[{
   RowBox[{"h", "/", "p"}], "*", 
   RowBox[{"(", 
    RowBox[{"e", "+", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"zp", ":=", "0"}]}], "Input",
 CellLabel->"In[346]:="],

Cell[BoxData[
 RowBox[{"vecvel", ":=", 
  RowBox[{"{", 
   RowBox[{"xp", ",", "yp", ",", "zp"}], "}"}]}]], "Input",
 CellLabel->"In[349]:="],

Cell["\<\
P1={{Cos[\[Omega]],-Sin[\[Omega]],0},{Sin[\[Omega]],Cos[\[Omega]],0},{0,0,1}};\
\>", "Input",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[350]:="],

Cell["P2={{1,0,0},{0,Cos[i],-Sin[i]},{0,Sin[i],Cos[i]}};", "Input",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[351]:="],

Cell["\<\
P3={{Cos[\[CapitalOmega]],-Sin[\[CapitalOmega]],0},{Sin[\[CapitalOmega]],Cos[\
\[CapitalOmega]],0},{0,0,1}};\
\>", "Input",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[352]:="],

Cell["P=P3.P2.P1;", "Input",
 AspectRatioFixed->False,
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"In[353]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"veclipos", "=", 
  RowBox[{"P", ".", "vecpos"}]}]], "Input",
 CellLabel->"In[354]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.533769999999997`", ",", "1.9323000000000035`", ",", 
   RowBox[{"-", "0.10954000000001525`"}]}], "}"}]], "Output",
 CellLabel->"Out[354]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"veclivel", "=", 
  RowBox[{"P", ".", "vecvel"}]}]], "Input",
 CellLabel->"In[355]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.003066557152635193`"}], ",", "0.007320136892539353`", ",", 
   "0.00003834168377823969`"}], "}"}]], "Output",
 CellLabel->"Out[355]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"veclivel", "*", "365.25"}]], "Input",
 CellLabel->"In[356]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.1200600000000043`"}], ",", "2.6736799999999987`", ",", 
   "0.014004300000002046`"}], "}"}]], "Output",
 CellLabel->"Out[356]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{879, 527},
WindowMargins->{{-8, Automatic}, {Automatic, -2}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (November 10, 2008)",
StyleDefinitions->"ArticleModern.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S5.16.1"->{
  Cell[716, 28, 813, 24, 62, "DefinitionBox",
   CellTags->"S5.16.1"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S5.16.1", 9388, 346}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 146, 4, 105, "Section"],
Cell[716, 28, 813, 24, 62, "DefinitionBox",
 CellTags->"S5.16.1"],
Cell[1532, 54, 1018, 23, 244, "Input"],
Cell[CellGroupData[{
Cell[2575, 81, 62, 0, 41, "Subsubsection"],
Cell[2640, 83, 862, 26, 84, "Input"],
Cell[3505, 111, 139, 5, 65, "Input"],
Cell[3647, 118, 266, 9, 66, "Input"],
Cell[CellGroupData[{
Cell[3938, 131, 148, 5, 43, "Input"],
Cell[4089, 138, 72, 1, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4198, 144, 157, 5, 43, "Input"],
Cell[4358, 151, 72, 1, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4467, 157, 119, 3, 43, "Input"],
Cell[4589, 162, 685, 13, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5311, 180, 106, 3, 43, "Input"],
Cell[5420, 185, 71, 1, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5528, 191, 207, 7, 43, "Input"],
Cell[5738, 200, 70, 1, 42, "Output"]
}, Open  ]],
Cell[5823, 204, 248, 8, 59, "Input"],
Cell[CellGroupData[{
Cell[6096, 216, 104, 3, 43, "Input"],
Cell[6203, 221, 137, 4, 42, "Output"]
}, Open  ]],
Cell[6355, 228, 316, 8, 84, "Input"],
Cell[6674, 238, 152, 4, 43, "Input"],
Cell[6829, 244, 428, 14, 84, "Input"],
Cell[7260, 260, 140, 4, 43, "Input"],
Cell[7403, 266, 186, 5, 43, "Input"],
Cell[7592, 273, 150, 3, 43, "Input"],
Cell[7745, 278, 216, 6, 43, "Input"],
Cell[7964, 286, 111, 3, 43, "Input"],
Cell[CellGroupData[{
Cell[8100, 293, 109, 3, 43, "Input"],
Cell[8212, 298, 181, 4, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8430, 307, 109, 3, 43, "Input"],
Cell[8542, 312, 193, 5, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8772, 322, 86, 2, 43, "Input"],
Cell[8861, 326, 187, 5, 42, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

