(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6473,        232]*)
(*NotebookOutlinePosition[      7279,        261]*)
(*  CellTagsIndexPosition[      7207,        255]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
HIPERBOLA
Obtencion de posicion y velocidad a aprtir de elementos orbitales.
Curso Mecanica Celeste 2005. Tabare Gallardo.\
\>", "Section"],

Cell[BoxData[{
    \(TraditionalForm\`unidad\ de\ tiempo\  = \ dia\), "\n", 
    \(TraditionalForm\`unidad\ de\ distancia\  = \ ua\), "\n", 
    \(TraditionalForm\`unidad\ de\ masa\  = \ sol\)}], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.16.1"],

Cell[BoxData[{
    \(M := 1.0\), "\[IndentingNewLine]", 
    \(m := 0.0009548\), "\[IndentingNewLine]", 
    \(kgauss := 0.01720209895\), "\[IndentingNewLine]", 
    \(\[Mu] := kgauss*kgauss*\((M + m)\)\), "\[IndentingNewLine]", 
    \(a := \(-5.179995814935037\)\), "\[IndentingNewLine]", 
    \(e := 1.04871959170445102\), "\[IndentingNewLine]", 
    \(i := 1.3046833201072958*Pi/180\), "\[IndentingNewLine]", 
    \(\[Omega] := \(-84.90588389067327\)*Pi/180\), "\[IndentingNewLine]", 
    \(\[CapitalOmega] := 100.48313071118518*Pi/180\), "\[IndentingNewLine]", 
    \(T := \(-81.299453540603\)\), "\[IndentingNewLine]", 
    \(t := \(-82.0\)\)}], "Input",
  CellLabel->"In[210]:="],

Cell[BoxData[
    \(kepler[tt_, \[Epsilon]_, mm_] := 
      Module[{lista = {}, ee = tt}, 
        For[j = 1, j \[LessEqual] mm, \(j++\), 
          ee = ArcSinh[\(tt + ee\)\/\[Epsilon]]; lista = Append[lista, ee]]; 
        Return[lista]]\)], "Input",
  CellLabel->"In[221]:="],

Cell[BoxData[
    \(n := \@\(\(-\[Mu]\)\/a\^3\)\)], "Input",
  CellLabel->"In[222]:="],

Cell[BoxData[{
    \(p := a*\((1 - e*e)\)\), "\[IndentingNewLine]", 
    \(h := \@\(p*\[Mu]\)\)}], "Input",
  CellLabel->"In[223]:="],

Cell[BoxData[
    \(AM := n*\((t - T)\)\)], "Input",
  CellLabel->"In[225]:="],

Cell[BoxData[
    \(iteraciones := 500\)], "Input",
  CellLabel->"In[226]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(F1 = Last[kepler[AM, e, iteraciones - 1]]\)], "Input",
  CellLabel->"In[227]:="],

Cell[BoxData[
    \(\(-0.020957720284548842`\)\)], "Output",
  CellLabel->"Out[227]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(F = Last[kepler[AM, e, iteraciones]]\)], "Input",
  CellLabel->"In[228]:="],

Cell[BoxData[
    \(\(-0.020957720284589913`\)\)], "Output",
  CellLabel->"Out[228]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(r = a*\((1 - e*Cosh[F])\)\)], "Input",
  CellLabel->"In[229]:="],

Cell[BoxData[
    \(0.2535603424660547`\)], "Output",
  CellLabel->"Out[229]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Theta] = Sign[t - T]*ArcCos[\(p/r - 1\)\/e]\)], "Input",
  CellLabel->"In[230]:="],

Cell[BoxData[
    \(\(-0.1356908350133582`\)\)], "Output",
  CellLabel->"Out[230]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({r, \[Theta]}\)], "Input",
  CellLabel->"In[231]:="],

Cell[BoxData[
    \({0.2535603424660547`, \(-0.1356908350133582`\)}\)], "Output",
  CellLabel->"Out[231]="]
}, Open  ]],

Cell[BoxData[{
    \(\[Xi] := r*Cos[\[Theta]]\), "\[IndentingNewLine]", 
    \(\[Eta] := r*Sin[\[Theta]]\), "\[IndentingNewLine]", 
    \(\[Zeta] := 0\)}], "Input",
  CellLabel->"In[232]:="],

Cell[BoxData[
    \(vecpos := {\[Xi], \[Eta], \[Zeta]}\)], "Input",
  CellLabel->"In[235]:="],

Cell[BoxData[{
    \(xp := \(-h\)/p*Sin[\[Theta]]\), "\[IndentingNewLine]", 
    \(yp := h/p*\((e + Cos[\[Theta]])\)\), "\[IndentingNewLine]", 
    \(zp := 0\)}], "Input",
  CellLabel->"In[236]:="],

Cell[BoxData[
    \(vecvel := {xp, yp, zp}\)], "Input",
  CellLabel->"In[239]:="],

Cell["\<\
P1={{Cos[\[Omega]],-Sin[\[Omega]],0},{Sin[\[Omega]],Cos[\[Omega]],0},{0,0,1}};\
\
\>", "Input",
  CellLabel->"In[240]:=",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["P2={{1,0,0},{0,Cos[i],-Sin[i]},{0,Sin[i],Cos[i]}};", "Input",
  CellLabel->"In[241]:=",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
P3={{Cos[\[CapitalOmega]],-Sin[\[CapitalOmega]],0},{Sin[\[CapitalOmega]],Cos[\
\[CapitalOmega]],0},{0,0,1}};\
\>", "Input",
  CellLabel->"In[242]:=",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["P=P3.P2.P1;", "Input",
  CellLabel->"In[243]:=",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
    \(veclipos = P . vecpos\)], "Input",
  CellLabel->"In[244]:="],

Cell[BoxData[
    \({0.25114815180074723`, 
      0.034412129971273304`, \(-0.005767012173732377`\)}\)], "Output",
  CellLabel->"Out[244]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(veclivel = P . vecvel\)], "Input",
  CellLabel->"In[245]:="],

Cell[BoxData[
    \({\(-0.009989725547942536`\), 0.047892288446749545`, 
      0.00002526131677985815`}\)], "Output",
  CellLabel->"Out[245]="]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{878, 527},
WindowMargins->{{5, Automatic}, {Automatic, 27}},
StyleDefinitions -> "ArticleModern.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.16.1"->{
    Cell[1928, 59, 292, 6, 80, "DefinitionBox",
      CellTags->"S5.16.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.16.1", 7105, 248}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 149, 4, 109, "Section"],
Cell[1928, 59, 292, 6, 80, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[2223, 67, 685, 12, 245, "Input"],
Cell[2911, 81, 278, 6, 100, "Input"],
Cell[3192, 89, 86, 2, 66, "Input"],
Cell[3281, 93, 133, 3, 67, "Input"],
Cell[3417, 98, 78, 2, 45, "Input"],
Cell[3498, 102, 77, 2, 45, "Input"],

Cell[CellGroupData[{
Cell[3600, 108, 100, 2, 45, "Input"],
Cell[3703, 112, 86, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3826, 119, 95, 2, 45, "Input"],
Cell[3924, 123, 86, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4047, 130, 84, 2, 45, "Input"],
Cell[4134, 134, 79, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4250, 141, 104, 2, 57, "Input"],
Cell[4357, 145, 84, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4478, 152, 72, 2, 45, "Input"],
Cell[4553, 156, 107, 2, 44, "Output"]
}, Open  ]],
Cell[4675, 161, 190, 4, 85, "Input"],
Cell[4868, 167, 93, 2, 45, "Input"],
Cell[4964, 171, 197, 4, 85, "Input"],
Cell[5164, 177, 81, 2, 45, "Input"],
Cell[5248, 181, 191, 6, 45, "Input"],
Cell[5442, 189, 153, 3, 45, "Input"],
Cell[5598, 194, 219, 6, 45, "Input"],
Cell[5820, 202, 114, 3, 45, "Input"],

Cell[CellGroupData[{
Cell[5959, 209, 80, 2, 45, "Input"],
Cell[6042, 213, 140, 3, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6219, 221, 80, 2, 45, "Input"],
Cell[6302, 225, 143, 3, 44, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

