(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7100,        223]*)
(*NotebookOutlinePosition[      7907,        252]*)
(*  CellTagsIndexPosition[      7835,        246]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
PARABOLA
Obtencion de posicion y velocidad a aprtir de elementos orbitales.
Curso Mecanica Celeste 2005. Tabare Gallardo.\
\>", "Section"],

Cell[BoxData[{
    \(TraditionalForm\`unidad\ de\ tiempo\  = \ dia\), "\n", 
    \(TraditionalForm\`unidad\ de\ distancia\  = \ ua\), "\n", 
    \(TraditionalForm\`unidad\ de\ masa\  = \ sol\)}], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.16.1"],

Cell[BoxData[{
    \(M := 1.0\), "\[IndentingNewLine]", 
    \(m := 0.0009548\), "\[IndentingNewLine]", 
    \(kgauss := 0.01720209895\), "\[IndentingNewLine]", 
    \(\[Mu] := kgauss*kgauss*\((M + m)\)\), "\[IndentingNewLine]", 
    \(q := 5.179995814935037\), "\[IndentingNewLine]", 
    \(e := 1.0\), "\[IndentingNewLine]", 
    \(i := 1.3046833201072958*Pi/180\), "\[IndentingNewLine]", 
    \(\[Omega] := \(-84.90588389067327\)*Pi/180\), "\[IndentingNewLine]", 
    \(\[CapitalOmega] := 100.48313071118518*Pi/180\), "\[IndentingNewLine]", 
    \(T := \(-81.299453540603\)\), "\[IndentingNewLine]", 
    \(t := \(-83.0\)\)}], "Input",
  CellLabel->"In[246]:="],

Cell[BoxData[
    \(n := \@\(\[Mu]\/\(2*q\^3\)\)\)], "Input",
  CellLabel->"In[257]:="],

Cell[BoxData[{
    \(p := 2*q\), "\[IndentingNewLine]", 
    \(h := \@\(p*\[Mu]\)\)}], "Input",
  CellLabel->"In[258]:="],

Cell[BoxData[
    \(AM := n*\((t - T)\)\)], "Input",
  CellLabel->"In[260]:="],

Cell[CellGroupData[{

Cell[BoxData[{
    \(paramp := 3\), "\[IndentingNewLine]", 
    \(paramq := \(-3\)*AM\), "\[IndentingNewLine]", 
    \(paramD := 1 + \((paramq/2)\)\^2\), "\[IndentingNewLine]", 
    \(paramu := \@\(Abs[\(-paramq\)/2 + \@paramD]\)\%3*
        Sign[\(-paramq\)/2 + \@paramD]\), "\[IndentingNewLine]", 
    \(paramv := \@\(Abs[\(-paramq\)/2 - \@paramD]\)\%3*
        Sign[\(-paramq\)/2 - \@paramD]\), "\[IndentingNewLine]", 
    \(solu := paramu + paramv\)}], "Input",
  CellLabel->"In[261]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(paramq\\)\\\" is similar to existing symbol \
\\\"\\!\\(paramp\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[261]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(paramu\\)\\\" is similar to existing symbols \
\\!\\({paramp, paramq}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[261]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(paramv\\)\\\" is similar to existing symbols \
\\!\\({paramp, paramq, paramu}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[261]:="]
}, Open  ]],

Cell[BoxData[
    \(\[Theta] := 2*ArcTan[solu]\)], "Input",
  CellLabel->"In[267]:="],

Cell[BoxData[
    \(r := p\/\(1 + Cos[\[Theta]]\)\)], "Input",
  CellLabel->"In[268]:="],

Cell[BoxData[{
    \(\[Xi] := r*Cos[\[Theta]]\), "\[IndentingNewLine]", 
    \(\[Eta] := r*Sin[\[Theta]]\), "\[IndentingNewLine]", 
    \(\[Zeta] := 0\)}], "Input",
  CellLabel->"In[269]:="],

Cell[BoxData[
    \(vecpos := {\[Xi], \[Eta], \[Zeta]}\)], "Input",
  CellLabel->"In[272]:="],

Cell[BoxData[{
    \(xp := \(-h\)/p*Sin[\[Theta]]\), "\[IndentingNewLine]", 
    \(yp := h/p*\((e + Cos[\[Theta]])\)\), "\[IndentingNewLine]", 
    \(zp := 0\)}], "Input",
  CellLabel->"In[273]:="],

Cell[BoxData[
    \(vecvel := {xp, yp, zp}\)], "Input",
  CellLabel->"In[276]:="],

Cell["\<\
P1={{Cos[\[Omega]],-Sin[\[Omega]],0},{Sin[\[Omega]],Cos[\[Omega]],0},{0,0,1}};\
\
\>", "Input",
  CellLabel->"In[277]:=",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["P2={{1,0,0},{0,Cos[i],-Sin[i]},{0,Sin[i],Cos[i]}};", "Input",
  CellLabel->"In[278]:=",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
P3={{Cos[\[CapitalOmega]],-Sin[\[CapitalOmega]],0},{Sin[\[CapitalOmega]],Cos[\
\[CapitalOmega]],0},{0,0,1}};\
\>", "Input",
  CellLabel->"In[279]:=",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["P=P3.P2.P1;", "Input",
  CellLabel->"In[280]:=",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
    \(veclipos = P . vecpos\)], "Input",
  CellLabel->"In[281]:="],

Cell[BoxData[
    \({4.993283305911946`, 
      1.3732568054984802`, \(-0.11751414217442369`\)}\)], "Output",
  CellLabel->"Out[281]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(veclivel = P . vecvel\)], "Input",
  CellLabel->"In[282]:="],

Cell[BoxData[
    \({\(-0.002853401575352175`\), 0.010306226068375878`, 
      0.000021194311189355907`}\)], "Output",
  CellLabel->"Out[282]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({r, \[Theta]}\)], "Input",
  CellLabel->"In[283]:="],

Cell[BoxData[
    \({5.180011776102233`, \(-0.0035107278837242903`\)}\)], "Output",
  CellLabel->"Out[283]="]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{879, 527},
WindowMargins->{{-8, Automatic}, {Automatic, -2}},
StyleDefinitions -> "ArticleModern.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.16.1"->{
    Cell[1927, 59, 292, 6, 80, "DefinitionBox",
      CellTags->"S5.16.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.16.1", 7733, 239}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 148, 4, 109, "Section"],
Cell[1927, 59, 292, 6, 80, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[2222, 67, 664, 12, 245, "Input"],
Cell[2889, 81, 87, 2, 66, "Input"],
Cell[2979, 85, 121, 3, 67, "Input"],
Cell[3103, 90, 78, 2, 45, "Input"],

Cell[CellGroupData[{
Cell[3206, 96, 491, 9, 195, "Input"],
Cell[3700, 107, 391, 6, 14, "Message"],
Cell[4094, 115, 392, 6, 14, "Message"],
Cell[4489, 123, 402, 7, 29, "Message"]
}, Open  ]],
Cell[4906, 133, 85, 2, 45, "Input"],
Cell[4994, 137, 88, 2, 57, "Input"],
Cell[5085, 141, 190, 4, 85, "Input"],
Cell[5278, 147, 93, 2, 45, "Input"],
Cell[5374, 151, 197, 4, 85, "Input"],
Cell[5574, 157, 81, 2, 45, "Input"],
Cell[5658, 161, 191, 6, 45, "Input"],
Cell[5852, 169, 153, 3, 45, "Input"],
Cell[6008, 174, 219, 6, 45, "Input"],
Cell[6230, 182, 114, 3, 45, "Input"],

Cell[CellGroupData[{
Cell[6369, 189, 80, 2, 45, "Input"],
Cell[6452, 193, 135, 3, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6624, 201, 80, 2, 45, "Input"],
Cell[6707, 205, 144, 3, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6888, 213, 72, 2, 45, "Input"],
Cell[6963, 217, 109, 2, 44, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

