(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20520,        744]
NotebookOptionsPosition[     17004,        624]
NotebookOutlinePosition[     17732,        653]
CellTagsIndexPosition[     17662,        648]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Obtencion de elementos orbitales a partir de posicion y velocidad.
Curso Mecanica Celeste 2005. Tabare Gallardo.\
\>", "Section"],

Cell[BoxData[
 RowBox[{"<<", "\"\<VectorAnalysis`\>\""}]], "Input",
 CellTags->"S5.16.1",
 CellLabel->"In[357]:="],

Cell[CellGroupData[{

Cell["SetCoordinates[Cartesian[x, y, z]]", "Input",
 CellTags->"S5.16.1",
 CellLabel->"In[358]:="],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output",
 CellTags->"S5.16.1",
 CellLabel->"Out[358]="]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["\<\"DotProduct[\"\>", "MR"], Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"1\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox[",", "MR"], "\<\" \"\>", Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"2\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox["\<\"]\"\>", "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[
     BoxData[
      FormBox[
       RowBox[{"\<\"compute the dot product of the vectors \"\>", Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"1\"\>"], TraditionalForm]], 
         "InlineFormula"], "\<\" and \"\>", Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"2\"\>"], TraditionalForm]], 
         "InlineFormula"], "\<\" given in default coordinates\"\>"}], 
       TraditionalForm]]]},
    {Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["\<\"CrossProduct[\"\>", "MR"], Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"1\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox[",", "MR"], "\<\" \"\>", Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"2\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox["\<\"]\"\>", "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[
     BoxData[
      FormBox["\<\"compute the cross product of the vectors given in default \
coordinates\"\>", TraditionalForm]]]},
    {Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["\<\"ScalarTripleProduct[\"\>", "MR"], Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"1\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox[",", "MR"], "\<\" \"\>", Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"2\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox[",", "MR"], "\<\" \"\>", Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"3\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox["\<\"]\"\>", "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[
     BoxData[
      FormBox["\<\"compute the scalar triple product of the vectors given in \
default coordinates\"\>", TraditionalForm]]]},
    {Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["\<\"DotProduct[\"\>", "MR"], Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"1\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox[",", "MR"], "\<\" \"\>", Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"2\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox[",", "MR"], "\<\" \"\>", 
        StyleBox["\<\"coordsys\"\>", "TI"], 
        StyleBox["\<\"]\"\>", "MR"], 
        RowBox[{",", " "}], 
        StyleBox["\<\"CrossProduct[\"\>", "MR"], Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"1\"\>"], TraditionalForm]], 
         "InlineFormula"], ",", 
        StyleBox["\<\" \"\>", "TR"], Cell[BoxData[
         FormBox[
          SubscriptBox[
           StyleBox["\<\"v\"\>", "TI"], "\<\"2\"\>"], TraditionalForm]], 
         "InlineFormula"], 
        StyleBox[",", "MR"], "\<\" \"\>", 
        StyleBox["\<\"coordsys\"\>", "TI"], 
        StyleBox["\<\"]\"\>", "MR"], 
        RowBox[{",", "  ", 
         RowBox[{"etc", ".", " "}]}]}], TraditionalForm]]], Cell[BoxData[
      FormBox[
       RowBox[{"\<\"give the result when the vectors are given in the \
coordinate system \"\>", 
        StyleBox["\<\"coordsys\"\>", "TI"]}], TraditionalForm]]]}
   },
   GridBoxAlignment->{
    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
     "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], 
  TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.16]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}},
 CellTags->"S5.16.1"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"unidad", " ", "de", " ", "tiempo"}], " ", "=", " ", "dia"}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"unidad", " ", "de", " ", "distancia"}], " ", "=", " ", "ua"}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"unidad", " ", "de", " ", "masa"}], " ", "=", " ", "sol"}], 
  TraditionalForm]}], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.16]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}},
 CellTags->"S5.16.1"],

Cell[BoxData[{
 RowBox[{"M", ":=", "1.0"}], "\[IndentingNewLine]", 
 RowBox[{"m", ":=", "0.0009548"}], "\[IndentingNewLine]", 
 RowBox[{"kgauss", ":=", "0.01720209895"}], "\[IndentingNewLine]", 
 RowBox[{"\[Mu]", ":=", 
  RowBox[{"kgauss", "*", "kgauss", "*", 
   RowBox[{"(", 
    RowBox[{"M", "+", "m"}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"pos", ":=", 
  RowBox[{"{", 
   RowBox[{"4.53377", ",", " ", "1.93230", ",", 
    RowBox[{"-", "0.109540"}]}], "}"}]}]}], "Input",
 CellLabel->"In[359]:="],

Cell[BoxData[
 RowBox[{"vel", ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.12006"}], ",", " ", "2.67368", ",", " ", "0.0140043"}], 
    "}"}], "/", "365.25"}]}]], "Input",
 CellLabel->"In[364]:="],

Cell[BoxData[
 RowBox[{"t", ":=", "0"}]], "Input",
 CellLabel->"In[365]:="],

Cell[BoxData[
 RowBox[{"r", ":=", 
  RadicalBox[
   RowBox[{"DotProduct", "[", 
    RowBox[{"pos", ",", "pos"}], "]"}], "2"]}]], "Input",
 CellLabel->"In[366]:="],

Cell[BoxData[
 RowBox[{"v2", ":=", 
  RowBox[{"DotProduct", "[", 
   RowBox[{"vel", ",", "vel"}], "]"}]}]], "Input",
 CellLabel->"In[367]:="],

Cell[BoxData[
 RowBox[{"v", ":=", 
  SqrtBox["v2"]}]], "Input",
 CellLabel->"In[368]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vech", "=", 
  RowBox[{"CrossProduct", "[", 
   RowBox[{"pos", ",", "vel"}], "]"}]}]], "Input",
 CellLabel->"In[369]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0008759354307734427`", ",", "0.00016207829483641346`", ",", 
   "0.03911332542532512`"}], "}"}]], "Output",
 CellLabel->"Out[369]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"hx", ",", "hy", ",", "hz"}], "}"}], "=", "vech"}]], "Input",
 CellLabel->"In[370]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0008759354307734427`", ",", "0.00016207829483641346`", ",", 
   "0.03911332542532512`"}], "}"}]], "Output",
 CellLabel->"Out[370]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"h", ":=", 
  RadicalBox[
   RowBox[{"DotProduct", "[", 
    RowBox[{"vech", ",", "vech"}], "]"}], "2"]}]], "Input",
 CellLabel->"In[371]:="],

Cell[BoxData[
 RowBox[{"rv", ":=", 
  RowBox[{"DotProduct", "[", 
   RowBox[{"pos", ",", "vel"}], "]"}]}]], "Input",
 CellLabel->"In[372]:="],

Cell[BoxData[
 RowBox[{"i", ":=", 
  RowBox[{"ArcCos", "[", 
   RowBox[{"hz", "/", "h"}], "]"}]}]], "Input",
 CellLabel->"In[373]:="],

Cell[BoxData[
 RowBox[{"\[CapitalOmega]", ":=", 
  RowBox[{"ArcTan", "[", 
   RowBox[{
    RowBox[{"-", "hy"}], ",", "hx"}], "]"}]}]], "Input",
 CellLabel->"In[374]:="],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vecz", ":=", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"n1", ":=", 
  RowBox[{"CrossProduct", "[", 
   RowBox[{"vecz", ",", "vech"}], "]"}]}]}], "Input",
 CellLabel->"In[375]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"spell1\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Possible spelling error: new symbol name \\\"\\!\\(vecz\\)\
\\\" is similar to existing symbol \\\"\\!\\(vech\\)\\\". \\!\\(\\*ButtonBox[\
\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
 CellLabel->"From In[375]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["versor nodo", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", "=", 
  RowBox[{"n1", "/", 
   RadicalBox[
    RowBox[{"DotProduct", "[", 
     RowBox[{"n1", ",", "n1"}], "]"}], "2"]}]}]], "Input",
 CellLabel->"In[377]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.18194602313310274`"}], ",", "0.983308519573612`", ",", 
   "0.`"}], "}"}]], "Output",
 CellLabel->"Out[377]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"nx", ",", "ny", ",", "nz"}], "}"}], "=", "n"}]], "Input",
 CellLabel->"In[378]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.18194602313310274`"}], ",", "0.983308519573612`", ",", 
   "0.`"}], "}"}]], "Output",
 CellLabel->"Out[378]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vex", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"CrossProduct", "[", 
     RowBox[{"vel", ",", "vech"}], "]"}], "/", "\[Mu]"}], "-", 
   RowBox[{"pos", "/", "r"}]}]}]], "Input",
 CellLabel->"In[379]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04691771560170177`", ",", "0.013080739127989016`", ",", 
   RowBox[{"-", "0.0011049173868393353`"}]}], "}"}]], "Output",
 CellLabel->"Out[379]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ex", ",", "ey", ",", "ez"}], "}"}], "=", "vex"}]], "Input",
 CellLabel->"In[380]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04691771560170177`", ",", "0.013080739127989016`", ",", 
   RowBox[{"-", "0.0011049173868393353`"}]}], "}"}]], "Output",
 CellLabel->"Out[380]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"e", ":=", 
  RadicalBox[
   RowBox[{"DotProduct", "[", 
    RowBox[{"vex", ",", "vex"}], "]"}], "2"]}]], "Input",
 CellLabel->"In[381]:="],

Cell[BoxData[
 RowBox[{"a", ":=", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "/", "r"}], "-", 
     RowBox[{"v2", "/", "\[Mu]"}]}], ")"}], 
   RowBox[{"-", "1"}]]}]], "Input",
 CellLabel->"In[382]:="],

Cell[BoxData[
 RowBox[{"cosenow", ":=", 
  RowBox[{
   RowBox[{"DotProduct", "[", 
    RowBox[{"n", ",", "vex"}], "]"}], "/", "e"}]}]], "Input",
 CellLabel->"In[383]:="],

Cell[BoxData[
 RowBox[{"senow", ":=", 
  FractionBox["ez", 
   RowBox[{"e", "*", 
    RowBox[{"Sin", "[", "i", "]"}]}]]}]], "Input",
 CellLabel->"In[384]:="],

Cell[BoxData[
 RowBox[{"\[Omega]", ":=", 
  RowBox[{"ArcTan", "[", 
   RowBox[{"cosenow", ",", "senow"}], "]"}]}]], "Input",
 CellLabel->"In[385]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"a", "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"e", "*", "e"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[386]:="],

Cell[BoxData["5.167700584038607`"], "Output",
 CellLabel->"Out[386]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"cosenoverd", ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"p", "/", "r"}], "-", "1"}], "e"]}]], "Input",
 CellLabel->"In[387]:="],

Cell[BoxData[
 RowBox[{"senoverd", ":=", " ", 
  FractionBox[
   RowBox[{"ScalarTripleProduct", "[", 
    RowBox[{"vex", ",", "pos", ",", "vech"}], "]"}], 
   RowBox[{"r", " ", "e", " ", "h"}]]}]], "Input",
 CellLabel->"In[388]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Theta]", "=", 
  RowBox[{"ArcTan", "[", 
   RowBox[{"cosenoverd", ",", "senoverd"}], "]"}]}]], "Input",
 CellLabel->"In[389]:="],

Cell[BoxData["0.130958527758343`"], "Output",
 CellLabel->"Out[389]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"cosaex", ":=", 
  RowBox[{
   FractionBox["1", "e"], "-", 
   FractionBox["r", 
    RowBox[{"a", " ", "e"}]]}]}]], "Input",
 CellLabel->"In[390]:="],

Cell[BoxData[
 RowBox[{"senaex", ":=", 
  RowBox[{
   FractionBox["rv", 
    RowBox[{"e", " ", 
     SqrtBox[
      RowBox[{"a", " ", "\[Mu]"}]]}]], "/;", 
   RowBox[{"a", ">", "0"}]}]}]], "Input",
 CellLabel->"In[391]:="],

Cell[BoxData[
 RowBox[{"AE", ":=", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"cosaex", ",", "senaex"}], "]"}], "/;", 
   RowBox[{"a", ">", "0"}]}]}]], "Input",
 CellLabel->"In[392]:="],

Cell[BoxData[
 RowBox[{"AM", ":=", 
  RowBox[{
   RowBox[{"AE", "-", 
    RowBox[{"e", "*", 
     RowBox[{"Sin", "[", "AE", "]"}]}]}], "/;", 
   RowBox[{"a", ">", "0"}]}]}]], "Input",
 CellLabel->"In[393]:="],

Cell[BoxData[
 RowBox[{"T", ":=", 
  RowBox[{
   RowBox[{"t", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"AE", "-", 
       RowBox[{"e", "*", 
        RowBox[{"Sin", "[", "AE", "]"}]}]}], ")"}], "*", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "3"], "/", "\[Mu]"}]]}]}], "/;", 
   RowBox[{"a", ">", "0"}]}]}]], "Input",
 CellLabel->"In[394]:="],

Cell[BoxData[
 RowBox[{"Z", ":=", 
  RowBox[{"cosaex", "/;", 
   RowBox[{"a", "<", "0"}]}]}]], "Input",
 CellLabel->"In[395]:="],

Cell[BoxData[
 RowBox[{"F", ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Z", "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"Z", "*", "Z"}], "-", "1"}]]}], "]"}], "*", 
    RowBox[{"Sign", "[", "rv", "]"}]}], "/;", 
   RowBox[{"a", "<", "0"}]}]}]], "Input",
 CellLabel->"In[396]:="],

Cell[BoxData[
 RowBox[{"T", ":=", 
  RowBox[{"t", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"e", "*", 
       RowBox[{"Sinh", "[", "F", "]"}]}], "-", "F"}], ")"}], 
    SqrtBox[
     FractionBox[
      RowBox[{"-", 
       SuperscriptBox["a", "3"]}], "\[Mu]"]]}]}]}]], "Input",
 CellLabel->"In[397]:="],

Cell[BoxData[
 RowBox[{"q", ":=", 
  RowBox[{"a", "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", "e"}], ")"}]}]}]], "Input",
 CellLabel->"In[398]:="],

Cell[BoxData[
 RowBox[{"Q", ":=", 
  RowBox[{"a", "*", 
   RowBox[{"(", 
    RowBox[{"1", "+", "e"}], ")"}]}]}]], "Input",
 CellLabel->"In[399]:="],

Cell[BoxData[
 RowBox[{"\[Epsilon]", ":=", 
  FractionBox[
   RowBox[{"-", "\[Mu]"}], 
   RowBox[{"2", "*", "a"}]]}]], "Input",
 CellLabel->"In[400]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "v", ",", "\[Epsilon]"}], "}"}]], "Input",
 CellLabel->"In[401]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.9295895077075125`", ",", "0.007936601727478121`", ",", 
   RowBox[{"-", "0.00002859024947549855`"}]}], "}"}]], "Output",
 CellLabel->"Out[401]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "e", ",", "p", ",", "q", ",", "Q", ",", "T"}], 
  "}"}]], "Input",
 CellLabel->"In[402]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.179995814935037`", ",", "0.04871959170445102`", ",", 
   "5.167700584038607`", ",", "4.927628533800636`", ",", 
   "5.4323630960694365`", ",", 
   RowBox[{"-", "81.299453540603`"}]}], "}"}]], "Output",
 CellLabel->"Out[402]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "i", ",", "\[Omega]", ",", "\[CapitalOmega]", ",", "\[Theta]", ",", "AE", 
    ",", "AM"}], "}"}], "*", 
  RowBox[{"180", "/", "Pi"}]}]], "Input",
 CellLabel->"In[403]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3046833201072958`", ",", 
   RowBox[{"-", "84.90588389067327`"}], ",", "100.48313071118518`", ",", 
   "7.503370931799891`", ",", "7.147244380697578`", ",", 
   "6.799935923628909`"}], "}"}]], "Output",
 CellLabel->"Out[403]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1000, 651},
WindowMargins->{{Automatic, -5}, {Automatic, 39}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (November 10, 2008)",
StyleDefinitions->"ArticleModern.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S5.16.1"->{
  Cell[709, 27, 114, 3, 43, "Input",
   CellTags->"S5.16.1"],
  Cell[848, 34, 98, 2, 43, "Input",
   CellTags->"S5.16.1"],
  Cell[949, 38, 143, 4, 42, "Output",
   CellTags->"S5.16.1"],
  Cell[1107, 45, 4636, 119, 76, "DefinitionBox",
   CellTags->"S5.16.1"],
  Cell[5746, 166, 813, 24, 62, "DefinitionBox",
   CellTags->"S5.16.1"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S5.16.1", 17305, 634}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 139, 3, 83, "Section"],
Cell[709, 27, 114, 3, 43, "Input",
 CellTags->"S5.16.1"],
Cell[CellGroupData[{
Cell[848, 34, 98, 2, 43, "Input",
 CellTags->"S5.16.1"],
Cell[949, 38, 143, 4, 42, "Output",
 CellTags->"S5.16.1"]
}, Open  ]],
Cell[1107, 45, 4636, 119, 76, "DefinitionBox",
 CellTags->"S5.16.1"],
Cell[5746, 166, 813, 24, 62, "DefinitionBox",
 CellTags->"S5.16.1"],
Cell[6562, 192, 507, 12, 124, "Input"],
Cell[7072, 206, 220, 7, 43, "Input"],
Cell[7295, 215, 75, 2, 43, "Input"],
Cell[7373, 219, 162, 5, 48, "Input"],
Cell[7538, 226, 141, 4, 43, "Input"],
Cell[7682, 232, 88, 3, 47, "Input"],
Cell[CellGroupData[{
Cell[7795, 239, 144, 4, 43, "Input"],
Cell[7942, 245, 177, 5, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8156, 255, 137, 4, 43, "Input"],
Cell[8296, 261, 177, 5, 42, "Output"]
}, Open  ]],
Cell[8488, 269, 164, 5, 48, "Input"],
Cell[8655, 276, 141, 4, 43, "Input"],
Cell[8799, 282, 133, 4, 43, "Input"],
Cell[8935, 288, 168, 5, 43, "Input"],
Cell[CellGroupData[{
Cell[9128, 297, 258, 7, 64, "Input"],
Cell[9389, 306, 415, 8, 13, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9841, 319, 36, 0, 41, "Subsubsection"],
Cell[CellGroupData[{
Cell[9902, 323, 186, 6, 54, "Input"],
Cell[10091, 331, 169, 5, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10297, 341, 134, 4, 43, "Input"],
Cell[10434, 347, 169, 5, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10640, 357, 225, 7, 43, "Input"],
Cell[10868, 366, 187, 4, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11092, 375, 136, 4, 43, "Input"],
Cell[11231, 381, 187, 4, 42, "Output"]
}, Open  ]],
Cell[11433, 388, 162, 5, 48, "Input"],
Cell[11598, 395, 224, 8, 43, "Input"],
Cell[11825, 405, 169, 5, 43, "Input"],
Cell[11997, 412, 157, 5, 59, "Input"],
Cell[12157, 419, 149, 4, 43, "Input"],
Cell[CellGroupData[{
Cell[12331, 427, 172, 6, 43, "Input"],
Cell[12506, 435, 70, 1, 42, "Output"]
}, Open  ]],
Cell[12591, 439, 154, 5, 59, "Input"],
Cell[12748, 446, 231, 6, 60, "Input"],
Cell[CellGroupData[{
Cell[13004, 456, 154, 4, 43, "Input"],
Cell[13161, 462, 70, 1, 42, "Output"]
}, Open  ]],
Cell[13246, 466, 172, 6, 60, "Input"],
Cell[13421, 474, 222, 8, 62, "Input"],
Cell[13646, 484, 193, 6, 43, "Input"],
Cell[13842, 492, 208, 7, 43, "Input"],
Cell[14053, 501, 366, 13, 65, "Input"],
Cell[14422, 516, 128, 4, 43, "Input"],
Cell[14553, 522, 312, 11, 52, "Input"],
Cell[14868, 535, 324, 12, 77, "Input"],
Cell[15195, 549, 147, 5, 43, "Input"],
Cell[15345, 556, 147, 5, 43, "Input"],
Cell[15495, 563, 152, 5, 57, "Input"],
Cell[CellGroupData[{
Cell[15672, 572, 116, 3, 43, "Input"],
Cell[15791, 577, 187, 4, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16015, 586, 140, 4, 43, "Input"],
Cell[16158, 592, 271, 7, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16466, 604, 226, 7, 43, "Input"],
Cell[16695, 613, 269, 6, 42, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

